﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL.APIMobile.Model
{
    public class GExerciseData_LaczenieKolumn : GExerciseData
    {
        public class ExerciseDataStub : IExerciseDataStub
        {
            public ExerciseDataStub()
            {

            }

            public int id { get; set; }
            public string text { get; set; }
            public string correct { get; set; }
            public string answers { get; set; }
        }

        private List<ExerciseDataStub> _listStub = null;

        public List<ExerciseDataStub> ExerciseData
        {
            get
            {
                if (_listStub == null)
                {
                    _listStub = new List<ExerciseDataStub>();
                }

                return _listStub;
            }
        }

        public GExerciseData_LaczenieKolumn(ZSBELearning BLP, BL.ZSBELearning.ContextParam ContextParam)
            : base(BLP, ContextParam)
        {
            
        }

        public void Load()
        {
            if (ContextParam.ExerciseOut != null)
            {
                switch (ContextParam.ExerciseOut.Type)
                {
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Matching: MatchingLoad(ContextParam.ExerciseOut); break;
                }
            }
        }

        public void Check(List<GExerciseDataCheckOne> ListExerciseDataSave)
        {
            if (ContextParam.ExerciseIn != null)
            {
                switch (ContextParam.ExerciseIn.Type)
                {
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Matching: MatchingCheck(ContextParam.ExerciseIn, ListExerciseDataSave); break;
                }

                SetExerciseOwlSave();
            }
        }

        private void MatchingLoad(PI.GM.N610.ELearning.BL.BO.Exercise Exercise)
        {
            int _stubIndex = 0;

            Dictionary<long, string> _rightMatching = new Dictionary<long, string>();

            XmlNode _xmlMatching_Right = Exercise.XML.DocumentElement.SelectSingleNode(String.Format("{0}/{1}", PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Matching, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Matching_Right));
            if (_xmlMatching_Right != null)
            {
                XmlNodeList _listXmlSection = _xmlMatching_Right.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Section);
                foreach (XmlNode _loopXmlSection in _listXmlSection)
                {
                    int _loopSectionID = Gemini.Utility.XML.Attribute.Get.Int(_loopXmlSection, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.Id);
                    string _loopSectionText = Gemini.Utility.XML.Node.Get.CDATA(_loopXmlSection);
                    _rightMatching.Add(_loopSectionID, _loopSectionText);
                }
            }

            XmlNode _xmlMatching_Left = Exercise.XML.DocumentElement.SelectSingleNode(String.Format("{0}/{1}", PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Matching, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Matching_Left));
            if (_xmlMatching_Left != null)
            {
                XmlNodeList _listXmlSection = _xmlMatching_Left.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Section);
                foreach (XmlNode _loopXmlSection in _listXmlSection)
                {
                    _stubIndex++;

                    ExerciseDataStub _loopStub = new ExerciseDataStub();
                    _loopStub.id = _stubIndex;
                    _loopStub.text = Gemini.Utility.XML.Node.Get.CDATA(_loopXmlSection);
                    _loopStub.correct = String.Empty;

                    int _loopCorrectSectionID = Gemini.Utility.XML.Attribute.Get.Int(_loopXmlSection, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.AnswerId,0);

                    if (_rightMatching.ContainsKey(_loopCorrectSectionID))
                    {
                        _loopStub.correct = _rightMatching[_loopCorrectSectionID];
                    }

                    ExerciseData.Add(_loopStub);   
                }
            }
        }

        private void MatchingCheck(PI.GM.N610.ELearning.BL.BO.Exercise Exercise, List<GExerciseDataCheckOne> ListExerciseDataSave)
        {
            int _stubIndex = 0;

            Exercise.TmpPoints = 0;

            Dictionary<long, string> _rightMatching = new Dictionary<long, string>();

            XmlNode _xmlMatching_Right = Exercise.XML.DocumentElement.SelectSingleNode(String.Format("{0}/{1}", PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Matching, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Matching_Right));
            if (_xmlMatching_Right != null)
            {
                XmlNodeList _listXmlSection = _xmlMatching_Right.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Section);
                foreach (XmlNode _loopXmlSection in _listXmlSection)
                {
                    int _loopSectionID = Gemini.Utility.XML.Attribute.Get.Int(_loopXmlSection, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.Id);
                    string _loopSectionText = Gemini.Utility.XML.Node.Get.CDATA(_loopXmlSection);
                    _rightMatching.Add(_loopSectionID, _loopSectionText);
                }
            }

            XmlNode _xmlMatching_Left = Exercise.XML.DocumentElement.SelectSingleNode(String.Format("{0}/{1}", PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Matching, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Matching_Left));
            if (_xmlMatching_Left != null)
            {
                XmlNodeList _listXmlSection = _xmlMatching_Left.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Section);
                foreach (XmlNode _loopXmlSection in _listXmlSection)
                {
                    GExerciseDataCheckOne _loopExerciseDataSave = ListExerciseDataSave[_stubIndex];
                    GExerciseCheck _loopExerciseCheck = new GExerciseCheck();
                    _loopExerciseCheck.id = _stubIndex+1;

                    int _loopCorrectSectionID = Gemini.Utility.XML.Attribute.Get.Int(_loopXmlSection, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.AnswerId, 0);

                    if (_rightMatching.ContainsKey(_loopCorrectSectionID))
                    {
                        if (_loopExerciseDataSave.answers[0] == _rightMatching[_loopCorrectSectionID])
                        {
                            Exercise.TmpPoints++;
                            _loopExerciseCheck.success_arr.Add(true);
                        }
                        else
                        {
                            _loopExerciseCheck.success_arr.Add(false);
                        }
                    }
                    else
                    {
                        _loopExerciseCheck.success_arr.Add(false);
                    }

                    ExerciseCheck.Add(_loopExerciseCheck);
                    _stubIndex++;
                }
            }
        }
    }
}
